class UTmod expands Mutator config(UTmod_v3);

#exec TEXTURE IMPORT NAME=Xloc1 FILE=Textures\xloc1.bmp Group=Xloc MIPS=ON
#exec TEXTURE IMPORT NAME=Xloc2 FILE=Textures\xloc2.bmp Group=Xloc MIPS=ON
#exec TEXTURE IMPORT NAME=Xloc3 FILE=Textures\xloc3.bmp Group=Xloc MIPS=ON
#exec TEXTURE IMPORT NAME=RFlag FILE=Textures\RedFlag2.bmp Group=CTF MIPS=ON
#exec TEXTURE IMPORT NAME=BFlag FILE=Textures\BlueFlag2.bmp Group=CTF MIPS=ON

var config string 	DMgamename,
			TDMgamename,
			CTFgamename,
			CustomRifleName,
			CustomKillMessage,
			CustomRiflePickupMessage,
			CustomAmmoPickupMessage;

var config bool		bInit,
			bDropWeapons,
			bRemoveHealthVials,
			bRemoveMedBoxes,
			bRemoveHealthPackages,
			bRemoveArmors,
			bRemoveThighPads,
			bRemoveShieldBelts,
			bRemoveInvis,
			bRemoveAmplifiers,
			bRemoveJumpBoots,
			bUseCustomPickups,
			bTranslucentBodies,
			bUseSpawnprotection,
			bUseNewHUD,
			bUseNewScoreBoard,
			bHeadShotBonus,
			bCamperEnhanced,
			bSpawnWithTranslocator,
			bUseLongeRangeBonus;

var config int		HealthVialHealing,
			HealthVialRespawnTime,
			MedBoxHealing,
			MedBoxRespawnTime,
			HealthPackHealing,
			HealthPackRespawnTime,
			ArmorCharge,
			ArmorRespawnTime,
			ThighPadsCharge,
			ThighPadsRespawnTime,
			ShieldBeltCharge,
			ShieldBeltRespawnTime,
			JumpBootsCharge,
			JumpBootsRespawnTime,
			AmplifierCharge,
			AmplifierRespawnTime,
			InvisCharge,
			InvisRespawnTime,
			ProtectionTime,
			HealthBonus,
			MaxHealth,
			AmmoBonus,
			FragBonus;

var config string	HealthVialTexture1,
			HealthVialTexture2,
			HealthVialTexture3,
			MedBoxTexture1,
			MedBoxTexture2,
			HealthPackTexture1,
			HealthPackTexture2,
			ArmorTexture,
			ThighPadsTexture,
			ShieldBeltTexture,
			JumpBootsTexture,
			AmplifierTexture,
			InvisTexture1,
			InvisTexture2,
			DMtexture,
			RedTeamTexture,
			BlueTeamTexture,
			GreenTeamTexture,
			GoldTeamTexture,
			ExpireSound,
			HealthVialPickupSound,
			MedBoxPickupSound,
			HealthPackPickupSound,
			ArmorPickupSound,
			ThighPadsPickupSound,
			ShieldBeltPickupSound,
			JumpBootsPickupSound,
			AmplifierPickupSound,
			InvisPickupSound;

var config Byte		bLightRadius;

var texture		Vial1,
			Vial2,
			Vial3,
			Med1,
			Med2,
			HP1,
			HP2,
			Armor,
			Thigh,
			SBelt,
			Boots,
			AMP,
			Inv1,
			Inv2,
			DMt,
			REDt,
			BLUEt,
			GREENt,
			GOLDt;

var sound		ExpSound,
			Vial,
			MedBox,
			Keg,
			ArmorSnd,
			Thighs,
			Belts,
			BootSnd,
			AmpSnd,
			InvisSnd;

function LoadCustomTextures()
{
Vial1 = texture(DynamicLoadObject(HealthVialTexture1, class'Texture'));
Vial2 = texture(DynamicLoadObject(HealthVialTexture2, class'Texture'));
Vial3 = texture(DynamicLoadObject(HealthVialTexture3, class'Texture'));
Med1 = texture(DynamicLoadObject(MedBoxTexture1, class'Texture'));
Med2 = texture(DynamicLoadObject(MedBoxTexture2, class'Texture'));
HP1 = texture(DynamicLoadObject(HealthPackTexture1, class'Texture'));
HP2 = texture(DynamicLoadObject(HealthPackTexture2, class'Texture'));
Armor = texture(DynamicLoadObject(ArmorTexture, class'Texture'));
Thigh = texture(DynamicLoadObject(ThighPadsTexture, class'Texture'));
SBelt = texture(DynamicLoadObject(ShieldBeltTexture, class'Texture'));
Boots = texture(DynamicLoadObject(JumpBootsTexture, class'Texture'));
AMP = texture(DynamicLoadObject(AmplifierTexture, class'Texture'));
Inv1 = texture(DynamicLoadObject(InvisTexture1, class'Texture'));
Inv2 = texture(DynamicLoadObject(InvisTexture2, class'Texture'));
DMt = texture(DynamicLoadObject(DMtexture, class'Texture'));
REDt = texture(DynamicLoadObject(RedTeamTexture, class'Texture'));
BLUEt = texture(DynamicLoadObject(BlueTeamTexture, class'Texture'));
GREENt = texture(DynamicLoadObject(GreenTeamTexture, class'Texture'));
GOLDt = texture(DynamicLoadObject(GoldTeamTexture, class'Texture'));
ExpSound = Sound(DynamicLoadObject(ExpireSound, class'Sound'));
Vial = Sound(DynamicLoadObject(HealthVialPickupSound, class'Sound'));
MedBox = Sound(DynamicLoadObject(MedBoxPickupSound, class'Sound'));
Keg = Sound(DynamicLoadObject(HealthPackPickupSound, class'Sound'));
ArmorSnd = Sound(DynamicLoadObject(ArmorPickupSound, class'Sound'));
Thighs = Sound(DynamicLoadObject(ThighPadsPickupSound, class'Sound'));
Belts = Sound(DynamicLoadObject(ShieldBeltPickupSound, class'Sound'));
BootSnd = Sound(DynamicLoadObject(JumpBootsPickupSound, class'Sound'));
AmpSnd = Sound(DynamicLoadObject(AmplifierPickupSound, class'Sound'));
InvisSnd = Sound(DynamicLoadObject(InvisPickupSound, class'Sound'));
}

function ModifyPlayer(Pawn Other)
{
local Inventory inv;

	if ( bSpawnWithTranslocator )
		{
		DeathMatchPlus(Level.Game).GiveWeapon(Other,"UTmod_v3.DanesTranslocator");
		}

	if ( bUseSpawnprotection )
		{
		inv = Spawn(class'SpawnProtector');
		if( inv != None )
			{
			SpawnProtector(Inv).Charge = ProtectionTime;
			SpawnProtector(Inv).bLightRadius = bLightRadius;
			SpawnProtector(Inv).DMtexture = DMt;
			SpawnProtector(Inv).RedTeamTexture = REDt;
			SpawnProtector(Inv).BlueTeamTexture = BLUEt;
			SpawnProtector(Inv).GreenTeamTexture = GREENt;
			SpawnProtector(Inv).GoldTeamTexture = GOLDt;
			SpawnProtector(Inv).ExpireSound = ExpSound;
			inv.GiveTo(Other);
			inv.Activate();
			}	
		}

	if ( NextMutator != None )
		NextMutator.ModifyPlayer(Other);
}

function PreBeginPlay ()
{

	if ( bInit )
		return;

	Super.PreBeginPlay();

	Level.Game.BaseMutator.AddMutator(Level.Spawn(class'Stats'));

	if ( bUseLongeRangeBonus )
		{
		Level.Game.BaseMutator.AddMutator(Level.Spawn(class'LongShot'));
		}



	//if( Level.Game.Class == class'Botpack.DeathMatchPlus' )
	if ( Level.Game.bTeamGame )
		{
		if ( bUseNewHUD )
			{
			if( Level.Game.Class == class'Botpack.CTFGame' )
				{
				Level.Game.HUDType = Class'DSM_CTFHUD';
				}
			else
				{
				Level.Game.HUDType = Class'DSM_TDMHUD';
				}
			}

		if ( bUseNewScoreBoard )
			{
			if( Level.Game.Class == class'Botpack.CTFGame' )
				{
				Level.Game.ScoreBoardType = Class'DSM_CTFSB';
				}
			else
				{
				Level.Game.ScoreBoardType = Class'DSM_TDMSB';
				}
			}

		if( Level.Game.Class == class'Botpack.CTFGame' )
			{
			Level.Game.GameName = CTFgamename;
			}
		else
			{
			Level.Game.GameName = TDMgamename;
			}
		}
	else
		{
		if ( bUseNewHUD )
			Level.Game.HUDType=Class'DSM_DMHUD';
		if ( bUseNewScoreBoard )
			Level.Game.ScoreBoardType = Class'DSM_DMSB';
		Level.Game.GameName = DMgamename;
		}

	Level.Game.BaseMutator.AddMutator(Level.Spawn(class'Vampire'));

	LoadCustomTextures();

	bInit = True;
	
	settimer(1.0, true);
}

function Timer()
{
local Pawn P;
local string Spec[8];
local int i;
local Info_PRI IPRI;

	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn'))
			{
			if ( P.PlayerReplicationInfo.bIsSpectator )
				{
				for ( i=0;i<8;i++ )
					{
					if ( Spec[i] == "" )
						{
						Spec[i] = P.PlayerReplicationInfo.PlayerName;
						i=12;
						}
					}
				}
			}
		}
	for (P = Level.PawnList; P != None; P = P.NextPawn)
		{
		if ( P.IsA('PlayerPawn'))
			{
			Info_PRI(P.PlayerReplicationInfo).Spec1 = "";
			Info_PRI(P.PlayerReplicationInfo).Spec2 = "";
			Info_PRI(P.PlayerReplicationInfo).Spec3 = "";
			Info_PRI(P.PlayerReplicationInfo).Spec4 = "";
			Info_PRI(P.PlayerReplicationInfo).Spec5 = "";
			Info_PRI(P.PlayerReplicationInfo).Spec6 = "";
			Info_PRI(P.PlayerReplicationInfo).Spec7 = "";
			Info_PRI(P.PlayerReplicationInfo).Spec8 = "";
			}
		}
	if ( Spec[0] != "" )
		{
		for (P = Level.PawnList; P != None; P = P.NextPawn)
			{
			if ( P.IsA('PlayerPawn'))
				{
				Info_PRI(P.PlayerReplicationInfo).Spec1 = Spec[0];
				Info_PRI(P.PlayerReplicationInfo).Spec2 = Spec[1];
				Info_PRI(P.PlayerReplicationInfo).Spec3 = Spec[2];
				Info_PRI(P.PlayerReplicationInfo).Spec4 = Spec[3];
				Info_PRI(P.PlayerReplicationInfo).Spec5 = Spec[4];
				Info_PRI(P.PlayerReplicationInfo).Spec6 = Spec[5];
				Info_PRI(P.PlayerReplicationInfo).Spec7 = Spec[6];
				Info_PRI(P.PlayerReplicationInfo).Spec8 = Spec[7];
				}
			}
		}
}

simulated function bool AlwaysKeep(Actor Other)
{
	if (Other.IsA('PlayerPawn'))
        	{
		PlayerPawn(Other).PlayerReplicationInfoClass = class'Info_PRI';
		return true;
		}
	if ( bTranslucentBodies && Other.IsA('Carcass') )
		{
		Carcass(Other).Style=STY_Translucent;
		}
	if ( Other.IsA('FlagBase'))
		{
		if ( FlagBase(Other).Team == 0 )
			{
			FlagBase(Other).MultiSkins[0] = Texture'RFlag';
			}
		else
			{
			FlagBase(Other).MultiSkins[0] = Texture'BFlag';
			}
		}
	if ( bUseCustomPickups )
	{
	if ( Other.IsA('DanesHealthVial'))
		{
		DanesHealthVial(Other).HealingAmount = HealthVialHealing;
		DanesHealthVial(Other).RespawnTime = HealthVialRespawnTime;
		DanesHealthVial(Other).MultiSkins[0] = Vial1;
		DanesHealthVial(Other).MultiSkins[1] = Vial2;
		DanesHealthVial(Other).MultiSkins[2] = Vial3;
		DanesHealthVial(Other).PickupSound = Vial;
		}
	if ( Other.IsA('DanesMedBox'))
		{
		DanesMedBox(Other).HealingAmount = MedBoxHealing;
		DanesMedBox(Other).RespawnTime = MedBoxRespawnTime;
		DanesMedBox(Other).MultiSkins[1] = Med1;
		DanesMedBox(Other).MultiSkins[2] = Med2;
		DanesMedBox(Other).PickupSound = MedBox;
		}
	if ( Other.IsA('DanesHealthPack'))
		{
		DanesHealthPack(Other).HealingAmount = HealthPackHealing;
		DanesHealthPack(Other).RespawnTime = HealthPackRespawnTime;
		DanesHealthPack(Other).MultiSkins[1] = HP1;
		DanesHealthPack(Other).MultiSkins[2] = HP2;
		DanesHealthPack(Other).PickupSound = Keg;
		}
	if ( Other.IsA('Armor2'))
		{
		Armor2(Other).Charge = ArmorCharge;
		Armor2(Other).RespawnTime = ArmorRespawnTime;
		Armor2(Other).MultiSkins[1] = Armor;
		Armor2(Other).PickupSound = ArmorSnd;
		}
	if ( Other.IsA('DanesArmor2'))
		{
		DanesArmor2(Other).Charge = ArmorCharge;
		DanesArmor2(Other).RespawnTime = ArmorRespawnTime;
		DanesArmor2(Other).MultiSkins[1] = Armor;
		DanesArmor2(Other).PickupSound = ArmorSnd;
		}
	if ( Other.IsA('ThighPads'))
		{
		ThighPads(Other).Charge = ThighPadsCharge;
		ThighPads(Other).RespawnTime = ThighPadsRespawnTime;
		ThighPads(Other).MultiSkins[1] = Thigh;
		ThighPads(Other).MultiSkins[2] = Thigh;
		ThighPads(Other).PickupSound = Thighs;
		}
	if ( Other.IsA('DanesThighPads'))
		{
		DanesThighPads(Other).Charge = ThighPadsCharge;
		DanesThighPads(Other).RespawnTime = ThighPadsRespawnTime;
		DanesThighPads(Other).MultiSkins[1] = Thigh;
		DanesThighPads(Other).MultiSkins[2] = Thigh;
		DanesThighPads(Other).PickupSound = Thighs;
		}
	if ( Other.IsA('UT_ShieldBelt'))
		{
		UT_ShieldBelt(Other).Charge = ShieldBeltCharge;
		UT_ShieldBelt(Other).RespawnTime = ShieldBeltRespawnTime;
		UT_ShieldBelt(Other).MultiSkins[1] = SBelt;
		UT_ShieldBelt(Other).PickupSound = Belts;
		}
	if ( Other.IsA('DanesUT_ShieldBelt'))
		{
		DanesUT_ShieldBelt(Other).Charge = ShieldBeltCharge;
		DanesUT_ShieldBelt(Other).RespawnTime = ShieldBeltRespawnTime;
		DanesUT_ShieldBelt(Other).MultiSkins[1] = SBelt;
		DanesUT_ShieldBelt(Other).PickupSound = Belts;
		}
	if ( Other.IsA('UT_JumpBoots'))
		{
		UT_JumpBoots(Other).Charge = JumpBootsCharge;
		UT_JumpBoots(Other).RespawnTime = JumpBootsRespawnTime;
		UT_JumpBoots(Other).MultiSkins[1] = Boots;
		UT_JumpBoots(Other).PickupSound = BootSnd;
		}
	if ( Other.IsA('DanesUT_JumpBoots'))
		{
		DanesUT_JumpBoots(Other).Charge = JumpBootsCharge;
		DanesUT_JumpBoots(Other).RespawnTime = JumpBootsRespawnTime;
		DanesUT_JumpBoots(Other).MultiSkins[1] = Boots;
		DanesUT_JumpBoots(Other).PickupSound = BootSnd;
		}
	if ( Other.IsA('UDamage') && !Other.IsA('SpawnProtector') )
		{
		UDamage(Other).Charge = AmplifierCharge;
		UDamage(Other).RespawnTime = AmplifierRespawnTime;
		UDamage(Other).Texture = AMP;
		UDamage(Other).PickupSound = AmpSnd;
		}
	if ( Other.IsA('DanesUDamage'))
		{
		DanesUDamage(Other).Charge = AmplifierCharge;
		DanesUDamage(Other).RespawnTime = AmplifierRespawnTime;
		DanesUDamage(Other).Texture = AMP;
		DanesUDamage(Other).PickupSound = AmpSnd;
		}
	if ( Other.IsA('UT_invisibility'))
		{
		UT_invisibility(Other).Charge = InvisCharge;
		UT_invisibility(Other).RespawnTime = InvisRespawnTime;
		UT_invisibility(Other).Texture = Inv2;
		UT_invisibility(Other).MultiSkins[1] = Inv1;
		UT_invisibility(Other).PickupSound = InvisSnd;
		}
	if ( Other.IsA('DanesUT_invisibility'))
		{
		DanesUT_invisibility(Other).Charge = InvisCharge;
		DanesUT_invisibility(Other).RespawnTime = InvisRespawnTime;
		DanesUT_invisibility(Other).Texture = Inv2;
		DanesUT_invisibility(Other).MultiSkins[1] = Inv1;
		DanesUT_invisibility(Other).PickupSound = InvisSnd;
		}
	}
	if ( NextMutator != None )
		return ( NextMutator.AlwaysKeep(Other) );
	return false;
}

simulated function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{

	if ( Other.IsA('Translocator') && !Other.IsA('DanesTranslocator') )
		{
		ReplaceWith(Other,"UTmod_v3.DanesTranslocator");
		return false;
		}
	if ( Other.IsA('HealthVial') && bRemoveHealthVials )
		{
		return false;
		}
	if ( Other.IsA('HealthVial') && !Other.IsA('DanesHealthVial') && bUseCustomPickups )
		{
		ReplaceWith(Other,"UTmod_v3.DanesHealthVial");
		return false;
		}
	if ( Other.IsA('MedBox') && bRemoveMedBoxes )
		{
		return false;
		}
	if ( Other.IsA('MedBox') && !Other.IsA('DanesMedBox') && bUseCustomPickups )
		{
		ReplaceWith(Other,"UTmod_v3.DanesMedBox");
		return false;
		}
	if ( Other.IsA('HealthPack') && bRemoveHealthPackages )
		{
		return false;
		}
	if ( Other.IsA('HealthPack') && !Other.IsA('DanesHealthPack') && bUseCustomPickups )
		{
		ReplaceWith(Other,"UTmod_v3.DanesHealthPack");
		return false;
		}
	if ( Other.IsA('Armor2') )
		{
		if ( bRemoveArmors )
			{
			return false;
			}
		else if ( !Other.IsA('DanesArmor2') && bUseCustomPickups )
			{
			ReplaceWith(Other,"UTmod_v3.DanesArmor2");
			return false;
			}
		}
	if ( Other.IsA('ThighPads') )
		{
		if ( bRemoveThighPads )
			{
			return false;
			}
		else if ( !Other.IsA('DanesThighPads') && bUseCustomPickups )
			{
			ReplaceWith(Other,"UTmod_v3.DanesThighPads");
			return false;
			}
		}
	if ( Other.IsA('UT_ShieldBelt') )
		{
		if ( bRemoveShieldBelts )
			{
			return false;
			}
		else if ( !Other.IsA('DanesUT_ShieldBelt') && bUseCustomPickups )
			{
			ReplaceWith(Other,"UTmod_v3.DanesUT_ShieldBelt");
			return false;
			}
		}
	if ( Other.IsA('UT_JumpBoots') )
		{
		if ( bRemoveJumpBoots )
			{
			return false;
			}
		else if ( !Other.IsA('DanesUT_JumpBoots') && bUseCustomPickups )
			{
			ReplaceWith(Other,"UTmod_v3.DanesUT_JumpBoots");
			return false;
			}
		}
	if ( Other.IsA('UDamage') && !Other.IsA('SpawnProtector') )
		{
		if ( bRemoveAmplifiers )
			{
			return false;
			}
		else if ( !Other.IsA('DanesUDamage') && bUseCustomPickups )
			{
			ReplaceWith(Other,"UTmod_v3.DanesUDamage");
			return false;
			}
		}
	if ( Other.IsA('UT_Invisibility') )
		{
		if ( bRemoveInvis )
			{
			return false;
			}
		else if ( !Other.IsA('DanesUT_Invisibility') && bUseCustomPickups )
			{
			ReplaceWith(Other,"UTmod_v3.DanesUT_Invisibility");
			return false;
			}
		}
	return true;
}

function bool PreventDeath (Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
local actor dropped;
local float speed;
local inventory inv;
local weapon weap;
local int X;
local Info_PRI IPRI;

	if ( bHeadShotBonus )
		{
		if ( damageType == 'Decapitated' )
			{
			Killer.Health += HealthBonus;
			Info_PRI(PlayerPawn(Killer).PlayerReplicationInfo).Headshots++;
			if ( Killer.Health > MaxHealth )
				{
				 Killer.Health = MaxHealth;
				}
			Killer.PlayerReplicationInfo.Score += FragBonus;
			Killer.Weapon.AmmoType.AmmoAmount += AmmoBonus;
			if ( Killer.Weapon.AmmoType.AmmoAmount > Killer.Weapon.AmmoType.MaxAmmo )
				{
				Killer.Weapon.AmmoType.AmmoAmount = Killer.Weapon.AmmoType.MaxAmmo;
				}
			if ( Level.Game.bTeamGame && Level.Game.Class != class'Botpack.CTFGame')
				{
				TeamGamePlus(Level.Game).Teams[Killer.PlayerReplicationInfo.Team].Score += FragBonus;
				}
			}
		}

	if ( bCamperEnhanced )
		{
		Killed.PlayerReplicationInfo.Score -= 1;
		}

	for (inv=Killed.Inventory; inv!=None; inv=inv.Inventory)
		{
		if ( bDropWeapons && inv.IsA('Weapon') && !inv.IsA('ImpactHammer') && !inv.IsA('ChainSaw') && !inv.IsA('Translocator') )
			{
			weap = Weapon(inv);

			//spawn inventory item to world:
			dropped = Spawn(weap.Class,,,Killed.Location);

			speed = VSize(Killed.Velocity);

			dropped.RemoteRole = ROLE_DumbProxy;
			dropped.SetPhysics(PHYS_Falling);
			dropped.bCollideWorld = true;
			dropped.Velocity = Normal(Killed.Velocity/speed + 0.5 * VRand()) * (speed + 280);

			weap = Weapon(dropped);

			weap.PickupAmmoCount = weap.default.PickupAmmoCount;

			if ( weap != None )
				{
				weap.RespawnTime = 0.0;
				weap.BecomePickup();
				weap.bTossedOut = true;
				weap.bWeaponStay = false;
				weap.GotoState('PickUp', 'Dropped');
				}
			}
		Killed.Inventory.Destroy();
		}

	if ( NextMutator != None )
		NextMutator.ScoreKill(Killer, Killed);
}

defaultproperties
{
}


